import {generatePath} from 'react-router-dom';

import {URLs} from 'constants/urls';
import {PRODUCTION_PROJECT_URL} from 'constants/common';

import {
    TFilterSlug,
    TGeoRegionSlug,
} from 'types/hotels/geoRegion/IGeoRegionInfo';

import {internalUrl} from 'utilities/url';

export const getRegionUrl = ({
    regionSlug,
    filterSlug,
}: {
    regionSlug: TGeoRegionSlug;
    filterSlug?: TFilterSlug;
}): string => {
    if (!regionSlug) {
        return '/';
    }

    if (filterSlug) {
        return internalUrl(
            generatePath(URLs.hotelsGeoRegionPageWithFilters, {
                regionSlug,
                filterSlug,
            }),
        );
    }

    return internalUrl(generatePath(URLs.hotelsGeoRegionPage, {regionSlug}));
};

export function getAbsoluteRegionUrl({
    regionSlug,
    filterSlug,
}: {
    regionSlug: TGeoRegionSlug;
    filterSlug?: TFilterSlug;
}): string {
    const url = getRegionUrl({regionSlug, filterSlug});

    return `${PRODUCTION_PROJECT_URL}${url}`;
}
