import {
    IRequiredOfferParams,
    IHotelOffer,
} from 'types/hotels/offer/IHotelOffer';
import {IHotel} from 'types/hotels/hotel/IHotel';
import {ISearchParamsForHotelUrl, ISearchFormFields} from './types';
import {ISearchInformation} from 'reducers/depreacted/hotels/searchInformation/types';
import {EPortalSeedReferer} from 'types/hotels/common/IAttribution';

import getISObyDate from 'components/Calendar/utilities/getISObyDate';

export const getSearchParamsForBaseHotelUrl = ({
    hotel,
    offers,
    offerRequestParams,
    seed,
}: {
    hotel: IHotel;
    offers?: IHotelOffer[];
    offerRequestParams?: Partial<IRequiredOfferParams>;
    seed?: EPortalSeedReferer;
}): ISearchParamsForHotelUrl => {
    const {hotelSlug} = hotel;
    const [firstOffer]: IHotelOffer[] = offers || [];
    const token = firstOffer?.token;

    return {
        seed,
        token,
        hotelSlug,
        ...offerRequestParams,
    };
};

export const getSearchParams = (
    searchFormFieldsValues: ISearchFormFields,
): ISearchInformation | undefined => {
    const {
        to: {selectedValue},
        adults,
        childrenAges,
        startDate,
        endDate,
    } = searchFormFieldsValues;

    const {
        name,
        redirectParams: {geoId, hotelSlug, permalink, sortOrigin},
    } = selectedValue;

    if (geoId || permalink || hotelSlug || sortOrigin) {
        return {
            adults,
            checkinDate: startDate && getISObyDate(startDate),
            checkoutDate: endDate && getISObyDate(endDate),
            childrenAges,
            geoObject: {
                geoId,
                name,
            },
            hotel: {
                name,
                permalink: permalink || '',
                hotelSlug: hotelSlug || '',
            },
            activeSuggest: selectedValue,
        };
    }
};
