import {URLs} from 'constants/urls';

import {internalUrl} from 'utilities/url';
import {getSearchUrlWithQuery} from 'projects/depreacted/hotels/utilities/urls/getSearchUrlWithQuery';

import {
    getHotelUrl,
    getHotelUrlByPermalink,
    getHotelUrlByHotelSlug,
} from './getHotelUrl';
import {
    getHotelsSearchUrl,
    getHotelsSearchUrlByParams,
    getShareHotelsSearchUrl,
} from './getHotelsSearchUrl';
import {createHotelPathGetter} from './createHotelPathGetter';
import {getSearchUrl} from './getSearchUrl';
import {getAbsoluteHotelUrl} from './getAbsoluteHotelUrl';
import {getRegionUrl, getAbsoluteRegionUrl} from './getRegionUrl';
import {getPathByOrderStatus} from './getPathByOrderStatus';

export {
    getSearchParamsForBaseHotelUrl,
    getSearchParams,
} from './getSearchParams';

export * from './types';

export const hotelsURLs = {
    getHotelsRootUrl: createHotelPathGetter(URLs.hotels),
    getBookPage: createHotelPathGetter(URLs.hotelsBook),
    getBookPaymentPage: createHotelPathGetter(URLs.hotelsBookPayment),
    getBookFinishPaymentPage: createHotelPathGetter(
        URLs.hotelsBookFinishPayment,
    ),
    getBookSuccessPage: createHotelPathGetter(URLs.hotelsBookSuccess),
    getOrderHappyPage: createHotelPathGetter(URLs.hotelsOrderHappyPage),
    getSearchPage: createHotelPathGetter(URLs.hotelsSearch),
    getHotelPageWithSlug: (slug: string, query?: {}): string =>
        internalUrl(`${URLs.hotels}/${slug}`, query),
    getBookErrorPage: createHotelPathGetter(URLs.hotelsBookError),
    getCancelledOrderPage: createHotelPathGetter(URLs.hotelsCancelledOrder),
    getAuthorizeVoucherPage: createHotelPathGetter(URLs.hotelsAuthorizeVoucher),

    getAbsoluteHotelUrl,

    getRegionUrl,
    getAbsoluteRegionUrl,

    getHotelUrl,
    getHotelUrlByPermalink,
    getHotelsSearchUrl,
    getHotelsSearchUrlByParams,
    getSearchUrlWithQuery,
    getShareHotelsSearchUrl,
    getSearchUrl,
    getHotelUrlByHotelSlug,

    getPathByOrderStatus,
};
