import {IRequiredOfferParams} from 'types/hotels/offer/IHotelOffer';
import {HotelSlugType, PermalinkType} from 'types/hotels/hotel/IHotel';
import {IHotelsSuggest} from 'types/hotels/common/ISearchSuggest';
import {EPortalSeedReferer} from 'types/hotels/common/IAttribution';

export interface ISearchParamsForHotelUrl
    extends Partial<IRequiredOfferParams> {
    hotelSlug: HotelSlugType;
    token?: string;
    seed?: EPortalSeedReferer;
}

export interface ISearchFormFields {
    to: {
        selectedValue: IHotelsSuggest;
    };
    adults: number;
    childrenAges: number[];
    startDate: Date;
    endDate: Date;
}

export interface ISearchLinkOptions {
    canSearchOnTravel: boolean;
    hasProductionOffers: boolean;
    hasDirectionSuggest?: boolean;
}

export interface ISearchLinkHotelParams {
    hotelPermalink?: PermalinkType;
}
