import React, {useCallback} from 'react';
import {useHistory} from 'react-router-dom';

import {EYtpReferer} from 'types/common/IAttribution';
import {EAviaGoal} from 'utilities/metrika/types/goals/avia';
import IPersonalizedHotelItem from 'server/api/PersonalizationApi/types/IPersonalizedHotelItem';

import {reachGoal} from 'utilities/metrika';
import humanizePeriod from 'utilities/dateUtils/humanizePeriod';
import getGuestsCount from 'projects/depreacted/hotels/pages/HotelPage/utilities/getGuestsCount';
import {getCrossSaleHotelsSearchUrl} from 'projects/avia/utilities/getCrossSaleHotelsSearchUrl';

import * as aviaCrossSaleKeyset from 'i18nNew/avia-crossSale';

import Flex from 'components/Flex/Flex';
import Text from 'components/Text/Text';
import HotelIcon from 'icons/24/Hotel';
import SearchPreset from 'components/SearchPreset/SearchPreset';

import cx from './CrossSalePreset.scss';

interface ICrossSalePresetProps {
    item: IPersonalizedHotelItem;
    width: 'auto' | 'max';
}

const CrossSalePreset: React.FC<ICrossSalePresetProps> = ({
    item,
    width,
}: ICrossSalePresetProps) => {
    const history = useHistory();

    const {offerSearchParams, region} = item;

    const handleClick = useCallback(() => {
        history?.push(
            getCrossSaleHotelsSearchUrl({
                ytpReferer: EYtpReferer.AVIA_MORDA_CROSSALE,
                geoId: region.geoId,
                offerSearchParams,
            }),
        );

        reachGoal(EAviaGoal.MORDA_CROSS_SALE_CLICK);
    }, [history, offerSearchParams, region]);

    const secondRow = humanizePeriod(
        offerSearchParams.checkinDate,
        offerSearchParams.checkoutDate,
        {
            short: true,
            checkSameDate: false,
            checkAnotherEndYear: false,
        },
    );

    return (
        <SearchPreset
            onClick={handleClick}
            title={region.linguistics.nominativeCase}
            secondRow={secondRow}
            thirdRow={aviaCrossSaleKeyset.guestsCount({
                guestsCount: getGuestsCount(offerSearchParams),
            })}
            Icon={HotelIcon}
            theme="blue"
            bottomText={
                <Flex flexWrap="wrap">
                    <Text
                        size="s-inset"
                        color="link"
                        className={cx('bottomText')}
                    >
                        {aviaCrossSaleKeyset.hotelForYour()}
                    </Text>
                    <Text
                        size="s-inset"
                        color="link"
                        className={cx('bottomText')}
                    >
                        {aviaCrossSaleKeyset.journeyDative()}
                    </Text>
                </Flex>
            }
            width={width}
        />
    );
};

export default React.memo(CrossSalePreset);
