import React, {MutableRefObject, useCallback, useMemo} from 'react';
import {useHistory} from 'react-router-dom';
import {useDispatch} from 'react-redux';

import {ESearchFormFieldName} from 'components/SearchForm/types';
import {EAviaGoal} from 'utilities/metrika/types/goals/avia';

import {setHistoryControlUsedAction} from 'reducers/avia/aviaLogMetrics/actions';
import {resetSearch} from 'reducers/avia/search/results/actions';

import {
    isOutdated,
    preparePreviousSearchData,
} from 'projects/avia/lib/previousSearches';
import {reachGoal} from 'utilities/metrika';

import * as i18n from 'i18nNew/common';

import {IFormFieldsRef} from 'components/SearchForm/SearchForm';
import SearchPreset from 'components/SearchPreset/SearchPreset';
import FlightIcon from 'icons/24/Flight';
import Text from 'components/Text/Text';
import TextSkeleton from 'components/Skeletons/TextSkeleton/TextSkeleton';
import Price from 'components/Price/Price';

import cx from './PreviousSearchPreset.scss';

interface IPreviousSearchPresetProps {
    // @typescript-eslint/no-explicit-any
    item: any;
    searchFormFieldsRef: MutableRefObject<IFormFieldsRef | undefined>;
    width: 'auto' | 'max';
    isLoading: boolean;
    // @typescript-eslint/no-explicit-any
    price: any | undefined;
}

const PreviousSearchPreset: React.FC<IPreviousSearchPresetProps> = props => {
    const {item, searchFormFieldsRef, width, isLoading, price} = props;
    const history = useHistory();
    const dispatch = useDispatch();

    const handleClick = useCallback(() => {
        if (isOutdated(item)) {
            searchFormFieldsRef.current?.focusFieldByName(
                ESearchFormFieldName.START_DATE,
            );
        } else {
            const url = '';

            if (url) {
                history?.push(url);
            }
        }

        dispatch(resetSearch());
        dispatch(
            setHistoryControlUsedAction({
                type: 'EHistoryControlType.PRESET',
            }),
        );

        reachGoal(EAviaGoal.PREVIOUS_SEARCHES_PRESET_CLICK);
    }, [item, dispatch, searchFormFieldsRef, history]);

    const {title, date} = preparePreviousSearchData(item);

    const secondRow = useMemo(() => {
        return (
            date || (
                <Text size="s" color="secondary">
                    {i18n.selectDates()}
                </Text>
            )
        );
    }, [date]);

    const priceNode = useMemo(() => {
        if (isLoading) {
            return (
                <TextSkeleton
                    className={cx('priceSkeleton')}
                    size="m"
                    withAnimation
                />
            );
        }

        const minPrice = price?.minPrice;

        if (!minPrice) {
            return;
        }

        return (
            <Price
                value={minPrice.value}
                currency={minPrice.currency}
                isRound
            />
        );
    }, [price, isLoading]);

    return (
        <SearchPreset
            title={title}
            secondRow={secondRow}
            sideTitle={priceNode}
            Icon={FlightIcon}
            width={width}
            onClick={handleClick}
        />
    );
};

export default React.memo(PreviousSearchPreset);
