import {useCallback, useState} from 'react';

import {IAviaMinPriceBatchSearchServiceParams} from 'server/services/AviaPriceIndexService/types/IAviaMinPriceBatchSearchService';

import {useAsyncState} from 'utilities/hooks/useAsyncState';

import {aviaPriceIndexBrowserProvider} from 'serviceProvider/avia/priceIndex/aviaPriceIndexBrowserProvider';

interface IMinPriceForSearchPresets {
    isLoading: boolean;
    isSuccess: boolean;
    isError: boolean;
    fetch(params: IAviaMinPriceBatchSearchServiceParams): Promise<void>;
    prices: any[];
}

export default function useMinPriceForSearchPresets(): IMinPriceForSearchPresets {
    const {reset, loading, success, error, isError, isSuccess, isLoading} =
        useAsyncState();
    const [prices, setPrices] = useState<any[]>([]);

    const fetch = useCallback(
        async (
            params: IAviaMinPriceBatchSearchServiceParams,
        ): Promise<void> => {
            reset();

            try {
                loading();

                const res =
                    await aviaPriceIndexBrowserProvider.minPriceBatchSearch(
                        params,
                    );

                setPrices(res.data);

                success();
            } catch (e) {
                setPrices([]);

                error();
            }
        },
        [error, loading, reset, success],
    );

    return {
        isLoading,
        isError,
        isSuccess,
        fetch,
        prices,
    };
}
