import {IAviaMinPriceSearchResult} from 'server/api/AviaPriceIndexApi/types/IAviaMinPriceBatchSearchApiResponse';
import IPersonalizedAviaItem from 'server/api/PersonalizationApi/types/IPersonalizedAviaItem';

import getPointIdByPointKey from './getPointIdByPointKey';

export default function findPrice(
    prices: IAviaMinPriceSearchResult[],
    item: IPersonalizedAviaItem,
): IAviaMinPriceSearchResult | undefined {
    return prices.find(price => {
        return (
            price.fromId === getPointIdByPointKey(item.from.pointKey) &&
            price.toId === getPointIdByPointKey(item.to.pointKey) &&
            price.forwardDate === item.when &&
            ((!price.backwardDate && !item.returnDate) ||
                price.backwardDate === item.returnDate)
        );
    });
}
