import differenceBy from 'lodash/differenceBy';

import {
    PREVIOUS_SEARCHES_COUNT,
    STORED_SEARCHES_KEY,
} from 'projects/index/IndexApp/blocks/IndexBuses/constants';

import {IBusesStoredSearch} from 'types/buses/common/IBusesStoredSearch';
import {IBusesSearchFormPointField} from 'projects/buses/components/SearchForm/types';

export default function storeSearch({
    from,
    to,
    when,
}: {
    from: IBusesSearchFormPointField;
    to: IBusesSearchFormPointField;
    when: string;
}): void {
    const {selectedValue: fromSuggest} = from;
    const {selectedValue: toSuggest} = to;

    if (typeof fromSuggest === 'boolean' || typeof toSuggest === 'boolean') {
        return;
    }

    const searchToStore = {
        from: fromSuggest,
        to: toSuggest,
        when,
    };

    try {
        const storedSearches: IBusesStoredSearch[] = JSON.parse(
            localStorage.getItem(STORED_SEARCHES_KEY) || '[]',
        );

        localStorage.setItem(
            STORED_SEARCHES_KEY,
            JSON.stringify(
                [
                    searchToStore,
                    ...differenceBy(
                        storedSearches,
                        [searchToStore],
                        ({from, to}) =>
                            from.slug === fromSuggest.slug &&
                            to.slug === toSuggest.slug,
                    ),
                ].slice(0, PREVIOUS_SEARCHES_COUNT),
            ),
        );
    } catch (err) {
        localStorage.setItem(STORED_SEARCHES_KEY, JSON.stringify([]));
    }
}
