import React, {MutableRefObject} from 'react';
import {useSelector} from 'react-redux';

import {IWithClassName} from 'types/withClassName';

import previousSearchesSelector from 'selectors/trains/previousSearchesSelector';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import getPreviousSearchKey from 'projects/trains/lib/previousSearches/getPreviousSearchKey';

import Flex from 'components/Flex/Flex';
import PreviousSearch from 'projects/index/IndexApp/blocks/IndexTrains/components/PreviousSearches/components/PreviousSearch/PreviousSearch';
import {IFormFieldsRef} from 'components/SearchForm/SearchForm';

interface IPreviousSearchesProps extends IWithClassName, IWithQaAttributes {
    searchFormFieldsRef: MutableRefObject<IFormFieldsRef | undefined>;
}

const PreviousSearches: React.FC<IPreviousSearchesProps> = props => {
    const {className, searchFormFieldsRef} = props;

    const previousSearches = useSelector(previousSearchesSelector);

    if (!previousSearches.items?.length) {
        return null;
    }

    return (
        <Flex
            className={className}
            between={2}
            inline
            nowrap
            {...prepareQaAttributes(props)}
        >
            {previousSearches.items.map(item => (
                <PreviousSearch
                    key={getPreviousSearchKey(item)}
                    item={item}
                    searchFormFieldsRef={searchFormFieldsRef}
                />
            ))}
        </Flex>
    );
};

export default React.memo(PreviousSearches);
