import React, {MutableRefObject, useCallback, useMemo} from 'react';
import {useHistory} from 'react-router-dom';
import {useDispatch} from 'react-redux';

import {ITrainsPreviousSearch} from 'types/trains/previousSearches/IPreviousSearch';
import {ESearchFormFieldName} from 'components/SearchForm/types';
import {ETrainsGoal} from 'utilities/metrika/types/goals/trains';

import {reachGoal} from 'utilities/metrika';
import {getTrainsHumanizeDatesLabel} from 'projects/trains/lib/date/getTrainsHumanizeDatesLabel';

import * as i18nBlock from 'i18nNew/common';

import {IFormFieldsRef} from 'components/SearchForm/SearchForm';
import SearchPreset from 'components/SearchPreset/SearchPreset';
import TrainIcon from 'icons/24/Train';

interface IPreviousSearchProps {
    item: ITrainsPreviousSearch;
    searchFormFieldsRef: MutableRefObject<IFormFieldsRef | undefined>;
}

const PreviousSearch: React.FC<IPreviousSearchProps> = props => {
    const {item, searchFormFieldsRef} = props;
    const {startDate, endDate} = item;
    const history = useHistory();
    const dispatch = useDispatch();

    const handleClick = useCallback(() => {
        if (item.startDate) {
        } else {
            searchFormFieldsRef.current?.focusFieldByName(
                ESearchFormFieldName.START_DATE,
            );
        }

        reachGoal(ETrainsGoal.PREVIOUS_SEARCHES_PRESET_CLICK);
    }, [dispatch, item, searchFormFieldsRef, history]);

    const searchDatesLabel = useMemo<string | undefined>(() => {
        return getTrainsHumanizeDatesLabel({startDate, endDate});
    }, [startDate, endDate]);

    return (
        <SearchPreset
            onClick={handleClick}
            title={i18nBlock.direction({
                from: item.from.title,
                to: item.to.title,
            })}
            secondRow={searchDatesLabel}
            Icon={TrainIcon}
        />
    );
};

export default React.memo(PreviousSearch);
