import React from 'react';

import {TRAINS_FAQ} from '../../constants/trainsFAQ';

import {IWithClassName} from 'types/withClassName';

import {deviceMods} from 'utilities/stylesUtils';
import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import * as trainsIndexTextsKeyset from 'i18nNew/trains-indexTexts';

import FAQ from 'components/FAQ/FAQ';
import CardWithDeviceLayout from 'components/CardWithDeviceLayout/CardWithDeviceLayout';

import cx from './TrainsIndexTexts.scss';

interface ITrainsIndexTextsProps extends IWithClassName, IWithQaAttributes {}

const TrainsIndexTexts: React.FC<ITrainsIndexTextsProps> = props => {
    const {className} = props;
    const deviceType = useDeviceType();

    return (
        <div className={cx(className, deviceMods('root', deviceType))}>
            <div className={cx('grid')}>
                <CardWithDeviceLayout
                    className={cx('gridItem', {gridItem_buyCheaper: true})}
                >
                    <h2
                        id="how-to-buy-a-ticket"
                        className={cx('buyCheaperTitle')}
                    >
                        {trainsIndexTextsKeyset.buyDashCheaperDashTitle()}
                    </h2>

                    <FAQ
                        items={TRAINS_FAQ}
                        {...prepareQaAttributes({
                            parent: props,
                            current: 'trainsFaq',
                        })}
                    />
                </CardWithDeviceLayout>

                <CardWithDeviceLayout
                    className={cx('gridItem', {
                        gridItem_additionalInformation: true,
                    })}
                >
                    <h4
                        id="additional-information"
                        className={cx('additionalInformationTitle')}
                    >
                        {trainsIndexTextsKeyset.additionalDashInformationDashTitle()}
                    </h4>

                    <p className={cx('additionalInformationText')}>
                        {trainsIndexTextsKeyset.additionalDashInformationDashText()}
                    </p>
                </CardWithDeviceLayout>
            </div>
        </div>
    );
};

export default React.memo(TrainsIndexTexts);
