import {EItemType} from 'projects/index/IndexApp/blocks/IndexTrains/components/TrainsIndexTexts/types/EItemType';

import * as trainsIndexTextsKeyset from 'i18nNew/trains-indexTexts';

export function getItemTitleAndText(type: EItemType): {
    title: string;
    text: string;
} {
    switch (type) {
        case EItemType.EARLIER_AND_CHEAPER:
            return {
                title: trainsIndexTextsKeyset.earlierDashAndDashCheaperDashV2DashTitle(),
                text: trainsIndexTextsKeyset.earlierDashAndDashCheaperDashV2DashText(),
            };
        case EItemType.UPPER_PLACES_HALF_PRICE:
            return {
                title: trainsIndexTextsKeyset.upperDashPlacesDashHalfDashPriceDashV2DashTitle(),
                text: trainsIndexTextsKeyset.upperDashPlacesDashHalfDashPriceDashV2DashText(),
            };
        case EItemType.FIX_PLATZKARTE_PRICE:
            return {
                title: trainsIndexTextsKeyset.fixDashPlatzkarteDashPriceDashV2DashTitle(),
                text: trainsIndexTextsKeyset.fixDashPlatzkarteDashPriceDashV2DashText(),
            };
        case EItemType.DISCOUNT_FOR_PUPILS:
            return {
                title: trainsIndexTextsKeyset.discountDashForDashPupilsDashV2DashTitle(),
                text: trainsIndexTextsKeyset.discountDashForDashPupilsDashV2DashText(),
            };
    }
}
