import React from 'react';

import {IWithClassName} from 'types/withClassName';

import getDirectId, {TIndexProjectName} from './utilities/getDirectId';
import {useMobile} from 'utilities/hooks/useMobile';

import {Direct} from 'components/Direct/Direct';

export interface IIndexDirectProps extends IWithClassName {
    projectName: TIndexProjectName;
}

const IndexDirect: React.FC<IIndexDirectProps> = ({projectName, className}) => {
    const isMobile = useMobile();
    const directId = getDirectId(projectName, isMobile);

    return (
        <Direct className={className} blockId={directId} isMobile={isMobile} />
    );
};

export default IndexDirect;
