import {EProjectName} from 'constants/common';

import {Platform} from 'types/Platform';

import getPlatform from 'utilities/deviceType/getPlatform';

export type TIndexProjectName =
    | typeof EProjectName.AVIA
    | typeof EProjectName.TRAINS
    | typeof EProjectName.HOTELS
    | typeof EProjectName.BUSES;

const dict: {
    [projectName in TIndexProjectName]: {
        [platform in Platform]: string;
    };
} = {
    [EProjectName.AVIA]: {
        [Platform.DESKTOP]: 'R-I-127716-38',
        [Platform.TOUCH]: 'R-I-242961-12',
    },
    [EProjectName.TRAINS]: {
        [Platform.DESKTOP]: 'R-I-272158-16',
        [Platform.TOUCH]: 'R-I-539137-7',
    },
    [EProjectName.HOTELS]: {
        [Platform.DESKTOP]: 'R-I-272158-22',
        [Platform.TOUCH]: 'R-I-539137-1',
    },
    [EProjectName.BUSES]: {
        [Platform.DESKTOP]: 'R-I-272158-18',
        [Platform.TOUCH]: 'R-I-539137-5',
    },
};

export default function getDirectId(
    projectName: TIndexProjectName,
    isMobile: boolean,
): string {
    const platform = getPlatform(isMobile);

    return dict[projectName][platform];
}
