import React from 'react';

import {IWithClassName} from 'types/withClassName';
import {ESubscriptionSource} from 'types/subscription/ESubscriptionSource';
import {ESubscriptionVerticalName} from 'types/subscription/ESubscriptionVerticalName';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {useIsUserSubscribed} from 'utilities/hooks/subscription/useIsUserSubscribed';

import InlineSubscription from 'containers/Subscriptions/Inline/InlineSubscription';

interface ISubscriptionContainerProps extends IWithClassName {
    vertical: ESubscriptionVerticalName;
}

const SubscriptionContainer: React.FC<ISubscriptionContainerProps> = ({
    ...props
}) => {
    const {isDesktop} = useDeviceType();
    const isUserSubscribed = useIsUserSubscribed();

    if (isUserSubscribed) {
        return null;
    }

    return (
        <InlineSubscription
            {...props}
            type="wide"
            source={ESubscriptionSource.INDEX}
            headerSize={isDesktop ? 'xxl' : 'xl'}
        />
    );
};

export default SubscriptionContainer;
