import {EProjectName} from 'constants/common';

import * as i18n from 'i18nNew/common';

export default function getMetaDescriptionText(
    projectName: EProjectName,
): string {
    switch (projectName) {
        case EProjectName.AVIA:
            return i18n.metaDotAviaDotDescription();
        case EProjectName.TRAINS:
            return i18n.metaDotTrainsDotDescription();
        case EProjectName.HOTELS:
            return i18n.metaDotHotelsDotDescription();
        case EProjectName.BUSES:
            return i18n.metaDotBusesDotDescription();
        default:
            return i18n.metaDotDescription();
    }
}
