import {EProjectName} from 'constants/common';

import * as i18n from 'i18nNew/common';

export default function getMetaOgDescriptionText(
    projectName: EProjectName,
): string {
    switch (projectName) {
        case EProjectName.AVIA:
            return i18n.metaDotAviaDotOgDescription();
        case EProjectName.TRAINS:
            return i18n.metaDotTrainsDotOgDescription();
        case EProjectName.HOTELS:
            return i18n.metaDotHotelsDotOgDescription();
        case EProjectName.BUSES:
            return i18n.metaDotBusesDotOgDescription();
        default:
            return '';
    }
}
