import {EProjectName} from 'constants/common';

import {getNow} from 'utilities/dateUtils';

import * as i18n from 'i18nNew/common';

export default function getMetaTitleText(projectName: EProjectName): string {
    switch (projectName) {
        case EProjectName.AVIA:
            return i18n.metaDotAviaDotTitle();
        case EProjectName.TRAINS: {
            const year = new Date(getNow()).getFullYear();

            return i18n.metaTrainsTitle({year});
        }
        case EProjectName.HOTELS:
            return i18n.metaDotHotelsDotTitle();
        case EProjectName.BUSES:
            return i18n.metaDotBusesDotTitle();
        default:
            return i18n.metaDotTitle();
    }
}
