import {createReducer, ActionType} from 'typesafe-actions';

import {IAdFoxParams} from 'types/AdFox';

import * as actions from 'reducers/common/banners/actions';

export interface IBannersState {
    adFoxParams: Nullable<IAdFoxParams>;
}

const INITIAL_STATE: IBannersState = {
    adFoxParams: null,
};

export default createReducer<IBannersState, ActionType<typeof actions>>(
    INITIAL_STATE,
).handleAction(actions.setAdFoxParams, (state, {payload}) => ({
    ...state,
    adFoxParams: payload,
}));
