import {ThunkAction} from 'redux-thunk';

import {ICountryFromApi} from 'reducers/common/countries/props';

import {
    action,
    getActionCreator,
    payload,
} from 'utilities/getActionCreator/getActionCreator';
import fetchCountries from './utilities/fetchCountries';

export const COUNTRIES_ACTION_TYPES = {
    REQUEST_COUNTRIES: action('common/countries/REQUEST_COUNTRIES'),
    RECEIVE_COUNTRIES_SUCCESS: action(
        'common/countries/RECEIVE_COUNTRIES_SUCCESS',
    ),
    RECEIVE_COUNTRIES_ERROR: action('common/countries/RECEIVE_COUNTRIES_ERROR'),
};

export const receiveCountriesStart = getActionCreator(
    COUNTRIES_ACTION_TYPES.REQUEST_COUNTRIES,
);

export const receiveCountriesSuccess = getActionCreator(
    COUNTRIES_ACTION_TYPES.RECEIVE_COUNTRIES_SUCCESS,
    payload<ICountryFromApi[]>(),
);

export const receiveCountriesError = getActionCreator(
    COUNTRIES_ACTION_TYPES.RECEIVE_COUNTRIES_ERROR,
    payload<{error: any}>(),
);

export const requestCountries =
    (): ThunkAction<any, any, void, any> => async dispatch => {
        dispatch(receiveCountriesStart());
        await fetchCountries()
            .then(
                data => receiveCountriesSuccess(data),
                err => receiveCountriesError(err),
            )
            .then(dispatch);
    };

export type CountriesActionsType = ReturnType<
    | typeof receiveCountriesSuccess
    | typeof receiveCountriesError
    | typeof receiveCountriesStart
>;
