import {ICountry} from 'types/common/ICountry';

import {normalizeCountries} from './utilities/normalizeCountries';

import {CountriesActionsType, COUNTRIES_ACTION_TYPES} from './actions';

export type GeoID = number;

export interface CountriesStateType {
    countries: GeoID[];
    countryData: Record<GeoID, ICountry>;
    isLoading: boolean;
    isFetched: boolean;
    isError: boolean;
}

const initialState: CountriesStateType = {
    countries: [],
    countryData: {},
    isFetched: false,
    isLoading: false,
    isError: false,
};

export default function countriesReducer(
    state: CountriesStateType = initialState,
    action: CountriesActionsType,
): CountriesStateType {
    switch (action.type) {
        case COUNTRIES_ACTION_TYPES.REQUEST_COUNTRIES:
            return {
                ...initialState,
                isLoading: true,
                isFetched: false,
            };
        case COUNTRIES_ACTION_TYPES.RECEIVE_COUNTRIES_SUCCESS:
            return {
                ...normalizeCountries(action.payload),
                isLoading: false,
                isFetched: true,
                isError: false,
            };
        case COUNTRIES_ACTION_TYPES.RECEIVE_COUNTRIES_ERROR:
            return {
                ...initialState,
                isLoading: false,
                isFetched: false,
                isError: true,
            };
    }

    return state;
}
