import {ICountry} from 'types/common/ICountry';

import {ICountryFromApi} from 'reducers/common/countries/props';

import {GeoID} from '../reducer';

export function normalizeCountries(rawCountries: ICountryFromApi[]) {
    const countries: GeoID[] = [];
    const countryData: Record<GeoID, ICountry> = {};

    for (const country of rawCountries) {
        // eslint-disable-next-line camelcase
        const {id, iso_name, name} = country;

        if (!id) {
            continue;
        }

        countries.push(id);
        countryData[id] = {
            geoId: id,
            code2: iso_name,
            title: name,
        };
    }

    return {
        countries,
        countryData,
    };
}
