import {createAsyncAction, createAction} from 'typesafe-actions';

import {ICurrenciesInfo} from 'server/services/CurrenciesService/types';

import {CurrencyType} from 'utilities/currency/CurrencyType';

export const setPreferredCurrency = createAction(
    'common/currencies/SET_PREFERRED_CURRENCY',
)<CurrencyType>();

export const currenciesFetchActions = createAsyncAction(
    'common/currencies/REQUEST',
    'common/currencies/SUCCESS',
    'common/currencies/FAILURE',
)<void, ICurrenciesInfo, void>();
