import {ActionType, createReducer} from 'typesafe-actions';

import {ICurrenciesInfo} from 'server/services/CurrenciesService/types';

import * as currenciesActions from 'reducers/common/currencies/actions';

import {CurrencyType} from 'utilities/currency/CurrencyType';

export const DEFAULT_CURRENCIES: ICurrenciesInfo = {
    nationalCurrency: CurrencyType.RUR,
    preferredCurrency: CurrencyType.RUR,
    availableCurrencies: [CurrencyType.RUR],
    currencyRates: {
        [CurrencyType.RUR]: 1,
    },
};

const {setPreferredCurrency, currenciesFetchActions} = currenciesActions;

export interface ICurrenciesStore {
    data: ICurrenciesInfo;
    loaded: boolean;
    timestamp: number;
    error: boolean;
}

const getInitialState = () => ({
    data: {
        ...DEFAULT_CURRENCIES,
    },
    loaded: false,
    timestamp: Date.now(),
    error: false,
});

export default createReducer<
    ICurrenciesStore,
    ActionType<typeof currenciesActions>
>(getInitialState())
    .handleAction(currenciesFetchActions.success, (state, {payload}) => ({
        data: payload,
        loaded: true,
        error: false,
        timestamp: Date.now(),
    }))
    .handleAction(currenciesFetchActions.failure, state => ({
        ...state,
        error: true,
    }))
    .handleAction(setPreferredCurrency, (state, {payload}) => ({
        ...state,
        data: {
            ...state.data,
            preferredCurrency: payload,
        },
    }));
