import {createReducer} from 'typesafe-actions';

import {TLD} from 'constants/tld';

import {IEnvironmentConfig} from 'reducers/common/commonReducerTypes';
import {
    setEnvironmentConfigAction,
    TEnvironmentConfigActions,
} from 'reducers/common/environmentConfig/actions';

const INITIAL_STATE: IEnvironmentConfig = {
    secureIFramePath: '',
    uxfeedbackIframeSrc: '',
    tld: TLD.RU,
    csrfTokenValidTill: null,
};

export default createReducer<IEnvironmentConfig, TEnvironmentConfigActions>(
    INITIAL_STATE,
).handleAction(setEnvironmentConfigAction, (state, {payload}) => payload);
