import {createReducer} from 'typesafe-actions';

import {
    openHotelsGeolocationErrorModalAction,
    closeHotelsGeolocationErrorModalAction,
    THotelsGeolocationErrorModalActionTypes,
} from './actions';

const initialState = {
    isOpen: false,
};

export interface IHotelsGeolocationErrorModal {
    isOpen: boolean;
}

/* Reducer */
export default createReducer<
    IHotelsGeolocationErrorModal,
    THotelsGeolocationErrorModalActionTypes
>(initialState)
    .handleAction(openHotelsGeolocationErrorModalAction, () => {
        return {
            isOpen: true,
        };
    })
    .handleAction(closeHotelsGeolocationErrorModalAction, () => {
        return {
            isOpen: false,
        };
    });
