import {ActionType, createReducer} from 'typesafe-actions';

import {ISeoExpsState} from 'reducers/common/seoExps/types';

import * as actions from 'reducers/common/seoExps/actions';

const INITIAL_STATE: ISeoExpsState = {
    modifications: [],
    pageId: null,
};

export default createReducer<ISeoExpsState, ActionType<typeof actions>>(
    INITIAL_STATE,
)
    .handleAction(actions.requestModifications, (_state, {payload}) => ({
        pageId: payload,
        modifications: [],
    }))
    .handleAction(actions.setModifications, (state, {payload}) => ({
        ...state,
        modifications: payload,
    }));
