import {Request} from '@yandex-data-ui/core/lib/types';
import {ESeoExpsService} from 'types/common/seoExps/ESeoExpsService';
import {ESeoExpsPlatform} from 'types/common/seoExps/ESeoExpsPlatform';
import {ESeoExpsCollection} from 'types/common/seoExps/ESeoExpsCollection';

import {CustomThunkAction} from 'reducers/trains/customDispatch';
import {
    requestModifications,
    setModifications,
} from 'reducers/common/seoExps/actions';

import seoExpsSelector from 'selectors/common/seoExps';

import {logWarning} from 'utilities/logger/logWarning';

import {seoExpsProvider} from 'serviceProvider/seoExps/seoExpsProvider';

interface IFetchModificationsParams {
    req?: Request;
    pageId: string;
    service?: ESeoExpsService;
    platform: ESeoExpsPlatform;
    collection: ESeoExpsCollection;
}

export function fetchModifications({
    req,
    pageId,
    platform,
    collection,
    service = ESeoExpsService.TRAVEL,
}: IFetchModificationsParams): CustomThunkAction<void> {
    return async (dispatch, getState) => {
        try {
            const seoExps = seoExpsSelector(getState());
            const encodedPage = encodeURIComponent(pageId);

            if (seoExps.pageId === encodedPage) {
                return;
            }

            dispatch(requestModifications(encodedPage));
            dispatch(
                setModifications(
                    await seoExpsProvider
                        .provider(req?.container)
                        .getModifications({
                            pageId: encodedPage,
                            service,
                            platform,
                            collection,
                        }),
                ),
            );
        } catch (e) {
            // Затираем имеющиеся модификации, чтоб они не миксовались с другими страницами
            dispatch(setModifications([]));
            logWarning({
                message:
                    '[YATRAVEL][SEO_EXPS] Проблема при получении данных для сео экспериментов',
            });
        }
    };
}
