import {ActionType, createReducer} from 'typesafe-actions';

import IAddFavoriteHotelRequestParams from 'server/api/HotelsFavoritesAPI/types/IAddFavoriteHotelRequestParams';

import {IAddFavoriteHotelParams} from 'reducers/depreacted/hotels/searchPage/search/thunkActions';
import * as actions from 'reducers/common/snackbar/actions';

export interface ISnackbarState {
    /* Cтрока, одназначно идентифицирующая последний экшен */
    lastAction: string | null;
    message?: string | React.ReactElement;
    hasCancellation: boolean;
    cancelAction?:
        | 'addFavoriteHotelOnSearch'
        | 'addFavoriteHotelOnFavoritesPage'
        | 'addFavoriteHotelOnHotelPage';
    cancelActionData?: IAddFavoriteHotelParams | IAddFavoriteHotelRequestParams;
    page: 'hotel' | 'favorites' | 'search' | 'journal' | null;
}

const initialState: ISnackbarState = {
    lastAction: null,
    hasCancellation: false,
    page: null,
};

export default createReducer<ISnackbarState, ActionType<typeof actions>>(
    initialState,
).handleAction(actions.setSnackbarInfo, (state, {payload}) => ({
    ...state,
    ...payload,
}));

export type TSetSnackbarInfo = (params: ISnackbarState) => void;
