import {Request} from '@yandex-data-ui/core/lib/types';

import {setSubscribedStatus} from 'reducers/common/subscription/status/actions';
// import {CustomThunkAction} from 'reducers/trains/customDispatch';

import {isAuthUser} from 'utilities/userInfo/isAuthUser';

import {notifierService} from 'serviceProvider';

export const fetchIsSubscribed = (
    req?: Request,
): ((dispatch, getState) => Promise<void>) => {
    return async (dispatch, getState): Promise<void> => {
        try {
            const userInfo = getState().common.userInfo;

            if (isAuthUser(userInfo) && userInfo.contacts.email) {
                const isSubscribed = await notifierService
                    .provider(req?.container)
                    .getStatus(userInfo.contacts.email);

                dispatch(setSubscribedStatus(Boolean(isSubscribed)));
            }
        } catch (e) {
            req?.utils.logError('Subscription status fetch failed', e as Error);
        }
    };
};
