import {createAction} from 'typesafe-actions';

import {
    IUserPlusInfo,
    TBlackboxUserInfo,
} from 'types/common/userInfo/TBlackboxUserInfo';

import {IFetchUserPassportConfig} from 'server/redux/common/fetchUserInfo';

import {IGeoLocation} from '../commonReducerTypes';

export const setUserInfoAction = createAction('COMMON.USER_INFO.SET')<{
    passportConfig: IFetchUserPassportConfig;
    yu: string;
    userInfo: TBlackboxUserInfo;
}>();

export const setUserGeoLocationAction = createAction(
    'COMMON.USER_INFO.SET_GEO_LOCATION',
)<IGeoLocation>();

export const setUserPlusInfoAction = createAction(
    'COMMON.USER_INFO.SET_PLUS_INFO',
)<IUserPlusInfo>();

export const setUserCitizenship = createAction(
    'COMMON.USER_INFO.SET_CITIZENSHIP',
)<string | undefined>();
