import {Request} from '@yandex-data-ui/core/lib/types';

import {CustomThunkAction} from 'reducers/trains/customDispatch';

import {commonService} from 'serviceProvider';

import {setUserPlusInfoAction} from './actions';

export const fetchUserPlusInfo = (
    req?: Request,
): CustomThunkAction<Promise<void>> => {
    return async (dispatch): Promise<void> => {
        try {
            const {points} = await commonService
                .provider(req?.container)
                .getUserYandexPlusInfo();

            dispatch(
                setUserPlusInfoAction({
                    hasPlus: typeof points === 'number',
                    points,
                }),
            );
        } catch (e) {
            req?.utils.logError('Plus info fetch failed', e as Error);
        }
    };
};
