import {createStore, applyMiddleware, compose} from 'redux';
import thunk from 'redux-thunk';
import createSagaMiddleware from 'redux-saga';
import {composeWithDevTools} from 'redux-devtools-extension';

import createRootReducer from 'reducers/rootReducer';

import rootSaga from 'sagas/rootSaga';
import {createSagaInjector} from 'sagas/createSagaInjector';

import {logError} from 'utilities/logger/logError';

/* global __REDUX_DEV_TOOLS__ __DEV__ */

const sagaOnErrorHandler = (error, {sagaStack}) => {
    logError(
        {
            message: '[YATRAVEL] Ошибка в процессе выполнения redux saga',
            block: 'ReduxSaga',
            source: sagaStack,
        },
        error,
    );

    console.error(error);
};

const sagaMiddleware = createSagaMiddleware({onError: sagaOnErrorHandler});
const reduxMiddlewares = [thunk, sagaMiddleware];
const reduxCompose =
    __REDUX_DEV_TOOLS__ && __DEV__
        ? composeWithDevTools({
              trace: true,
              traceLimit: 25,
              shouldHotReload: false,
          })
        : compose;
const preLoadedReduxState = window.__PRELOADED_REDUX_STATE__;

delete window.__PRELOADED_REDUX_STATE__;

export default () => {
    const store = createStore(
        createRootReducer(),
        preLoadedReduxState,
        reduxCompose(applyMiddleware(...reduxMiddlewares)),
    );

    store.injectSaga = createSagaInjector(sagaMiddleware.run);
    store.injectSaga(rootSaga);

    store.refreshReducers = () => {
        store.replaceReducer(createRootReducer());
    };

    return store;
};
