import {createAction, ActionType} from 'typesafe-actions';

import {TSetBookUserSelectPayload} from './types';

import {BOOK_USER_SELECT_ACTIONS} from './actionTypes';

/* Actions */

export const setBookUserSelectAction = createAction(
    BOOK_USER_SELECT_ACTIONS.SET,
)<TSetBookUserSelectPayload>();

export const resetBookUserSelectAction = createAction(
    BOOK_USER_SELECT_ACTIONS.RESET,
)();

/* Action Types */
export type TSetBookUserSelectActionType = (
    params: TSetBookUserSelectPayload,
) => void;

export type TResetBookUserSelectActionType = () => void;

export type TBookUserSelectActionTypes =
    | ActionType<typeof setBookUserSelectAction>
    | ActionType<typeof resetBookUserSelectAction>;
