import {createReducer} from 'typesafe-actions';

import {IBookUserSelect} from 'types/hotels/book/ICreateOrder';
import {EYandexPlusApplicationMode} from 'types/hotels/offer/IHotelOffer';

import {
    resetBookUserSelectAction,
    setBookUserSelectAction,
    TBookUserSelectActionTypes,
} from './actions';

const initialState: IBookUserSelect = {
    bedsGroupId: '0',
    useDeferredPayments: false,
    plusMode: EYandexPlusApplicationMode.TOPUP,
};

export default createReducer<IBookUserSelect, TBookUserSelectActionTypes>(
    initialState,
)
    .handleAction(setBookUserSelectAction, (state, {payload}) => ({
        ...state,
        ...payload,
    }))
    .handleAction(resetBookUserSelectAction, () => ({
        ...initialState,
    }));
