import {getType} from 'typesafe-actions';

import {IOrderRefundableInfo} from 'server/api/HotelsBookAPI/types/IOrderRefundableInfo';

import {
    fetchRefundableInfoActions,
    FetchRefundableInfoActionsType,
    setRefundModalVisible,
    SetRefundModalVisibleActionType,
    startCancelOrderActions,
    StartCancelOrderActionsType,
} from './actions';

/* Types */
export interface IOrderCancelAndRefundableInfo {
    readonly refundableInfo: {
        isSuccess: boolean;
        isError: boolean;
        isLoading: boolean;
        isRefundModalVisible: boolean;
        data?: IOrderRefundableInfo;
    };
    readonly cancelOrderInfo: {
        isSuccess: boolean;
        isError: boolean;
        isLoading: boolean;
    };
}

/* Initial State */

const initialState: IOrderCancelAndRefundableInfo = {
    refundableInfo: {
        isSuccess: false,
        isError: false,
        isLoading: false,
        isRefundModalVisible: false,
    },
    cancelOrderInfo: {
        isSuccess: false,
        isError: false,
        isLoading: false,
    },
};

/* Reducer */

export default (
    state: IOrderCancelAndRefundableInfo = initialState,
    action:
        | FetchRefundableInfoActionsType
        | StartCancelOrderActionsType
        | SetRefundModalVisibleActionType,
): IOrderCancelAndRefundableInfo => {
    switch (action.type) {
        /* Fetch Refundable Info */

        case getType(fetchRefundableInfoActions.request): {
            return {
                ...state,
                cancelOrderInfo: initialState.cancelOrderInfo,
                refundableInfo: {
                    ...state.refundableInfo,
                    isSuccess: false,
                    isError: false,
                    isLoading: true,
                },
            };
        }

        case getType(fetchRefundableInfoActions.success): {
            const {payload} = action;

            return {
                ...state,
                refundableInfo: {
                    ...state.refundableInfo,
                    isError: false,
                    isLoading: false,
                    isSuccess: true,
                    data: payload,
                },
            };
        }

        case getType(fetchRefundableInfoActions.failure): {
            return {
                ...state,
                refundableInfo: {
                    ...state.refundableInfo,
                    isSuccess: false,
                    isLoading: false,
                    isError: true,
                },
            };
        }

        /* Refundable modal */

        case getType(setRefundModalVisible): {
            return {
                ...state,
                refundableInfo: {
                    ...state.refundableInfo,
                    isRefundModalVisible: action.payload,
                },
            };
        }

        /* Start Cancel */

        case getType(startCancelOrderActions.request): {
            return {
                ...state,
                cancelOrderInfo: {
                    ...initialState.cancelOrderInfo,
                    isLoading: true,
                },
            };
        }

        case getType(startCancelOrderActions.success): {
            return {
                ...state,
                cancelOrderInfo: {
                    ...initialState.cancelOrderInfo,
                    isSuccess: true,
                },
            };
        }

        case getType(startCancelOrderActions.failure): {
            return {
                ...state,
                cancelOrderInfo: {
                    ...initialState.cancelOrderInfo,
                    isError: true,
                },
            };
        }

        default: {
            return state;
        }
    }
};
