import {createReducer} from 'typesafe-actions';

import {
    UNKNOWN_ORDER_ERROR,
    BOOK_FORM_SUBMITTED,
    INITIAL,
    NEED_AUTHORIZATION,
    REMOVED,
} from 'projects/depreacted/hotels/constants/hotelsBookingStatuses';

import {
    IOrder,
    IOrderConfirmationInfo,
    IOrderPayment,
    IOrderCancellationDetails,
    IOrderGuestsInfo,
} from 'server/api/HotelsBookAPI/types/IOrder';

import {
    TOrderInfoActionTypes,
    getOrderInfoActions,
    createOrderActions,
    startOrderPaymentActions,
    resetOrderInfoAction,
    orderNeedAuthorizationAction,
    removeOrderActions,
} from './actions';

export interface IOrderInfoReducer extends Partial<IOrder> {
    info: IOrder | {};
    status: string;
    orderId?: string;
    payment?: IOrderPayment;
    guestsInfo?: IOrderGuestsInfo;
    confirmationInfo?: IOrderConfirmationInfo;
    orderCancellationDetails?: IOrderCancellationDetails;
}

const initialState: IOrderInfoReducer = {
    info: {},
    status: INITIAL,
};

export default createReducer<IOrderInfoReducer, TOrderInfoActionTypes>(
    initialState,
)
    .handleAction(getOrderInfoActions.success, (state, {payload}) => {
        const {
            data: {
                orderId,
                status,
                payment,
                guestsInfo,
                refundableInfo,
                confirmationInfo,
                orderCancellationDetails,
                orderPriceInfo,
                tripId,
            },
        } = payload;

        return {
            ...state,
            orderId,
            status,
            payment,
            guestsInfo,
            refundableInfo,
            confirmationInfo,
            orderCancellationDetails,
            orderPriceInfo,
            tripId,
        };
    })
    .handleAction(createOrderActions.request, () => ({
        ...initialState,
        status: BOOK_FORM_SUBMITTED,
    }))
    .handleAction(
        [
            getOrderInfoActions.failure,
            createOrderActions.failure,
            startOrderPaymentActions.failure,
        ],
        () => ({
            ...initialState,
            status: UNKNOWN_ORDER_ERROR,
        }),
    )
    .handleAction(orderNeedAuthorizationAction, () => ({
        ...initialState,
        status: NEED_AUTHORIZATION,
    }))
    .handleAction(resetOrderInfoAction, () => ({...initialState}))
    .handleAction(
        [removeOrderActions.success, removeOrderActions.failure],
        () => ({
            ...initialState,
            status: REMOVED,
        }),
    );
