import {IOrder} from 'server/api/HotelsBookAPI/types/IOrder';
import {ICreateOrderRequest} from 'types/hotels/book/ICreateOrder';

import {IDevice} from 'reducers/common/commonReducerTypes';

export * from 'server/api/HotelsBookAPI/types/IOrder';

export interface IOrderInfoRequestPayload {
    orderId: string;
    finishPaymentPagePath?: string;
    /**
     * Флаг того что пользователь согласился продолжить бронивароние с ограничениями
     * Например с отклоненным промокодом
     */
    withRestrictions?: boolean;
    /**
     * Отправлен ли запрос startPayment
     */
    isPaymentStarted?: boolean;
}

export interface IStartPaymentRequestPayload {
    orderId: string;
    finishPaymentPagePath?: string;
}

export interface IOrderInfoSuccessPayload {
    data: IOrder;
}

export interface ICreateOrderInfoRequestPayload
    extends Omit<ICreateOrderRequest, 'subscription'> {
    deviceType?: IDevice;
    finishPaymentPagePath?: string;
}

export interface IRemoveOrderRequestPayload {
    orderId: string;
    token: string;
    label: string;
}
