import {createReducer} from 'typesafe-actions';

import {IAppliedPromoCodesInfo} from 'types/hotels/book/IApplyPromoCodes';

import {
    resetPromoCodesAction,
    estimateDiscountActions,
    TPromoCodesInfoActionTypes,
} from './actions';

export interface IBookPromoCodesReducer {
    isLoading: boolean;
    isSuccess: boolean;
    isFailed: boolean;
    data?: IAppliedPromoCodesInfo;
}

const initialState: IBookPromoCodesReducer = {
    isLoading: false,
    isSuccess: false,
    isFailed: false,
};

export default createReducer<
    IBookPromoCodesReducer,
    TPromoCodesInfoActionTypes
>(initialState)
    .handleAction(resetPromoCodesAction, () => initialState)
    .handleAction(estimateDiscountActions.request, () => ({
        ...initialState,
        isLoading: true,
    }))
    .handleAction(estimateDiscountActions.success, (_, {payload}) => ({
        isLoading: false,
        isSuccess: Boolean(payload.codeApplicationResults.length),
        isFailed: false,
        data: payload,
    }))
    .handleAction(estimateDiscountActions.failure, () => ({
        isLoading: false,
        isSuccess: false,
        isFailed: true,
    }));
