import {createAsyncAction, ActionType} from 'typesafe-actions';

import {IGeoRegionInfo} from 'types/hotels/geoRegion/IGeoRegionInfo';
import {IGeoRegionInfoRequestParams} from 'server/api/HotelsSearchAPI/types/IGeoRegionInfo';

import {EGeoRegionInfoActionTypes} from './actionTypes';

export const fetchGeoRegionInfoActions = createAsyncAction(
    EGeoRegionInfoActionTypes.START,
    EGeoRegionInfoActionTypes.SUCCESS,
    EGeoRegionInfoActionTypes.FAILED,
)<IGeoRegionInfoRequestParams, IGeoRegionInfo, undefined>();

export type TFetchGeoRegionInfoActionsType = ActionType<
    typeof fetchGeoRegionInfoActions
>;

export type TFetchGeoRegionInfo = (params: IGeoRegionInfoRequestParams) => void;
