import {createReducer} from 'typesafe-actions';

import {IGeoRegionInfo} from 'types/hotels/geoRegion/IGeoRegionInfo';

import {
    TFetchGeoRegionInfoActionsType,
    fetchGeoRegionInfoActions,
} from './actions';

/* Reducer Types */

export interface IGeoRegionInfoReducer {
    isLoading: boolean;
    isError: boolean;
    data?: IGeoRegionInfo;
}

/* Initial State */

const initialState: IGeoRegionInfoReducer = {
    isLoading: true,
    isError: false,
};

/* Reducer */

const geoRegionInfoReducer = createReducer<
    IGeoRegionInfoReducer,
    TFetchGeoRegionInfoActionsType
>(initialState)
    .handleAction(
        fetchGeoRegionInfoActions.request,
        (state): IGeoRegionInfoReducer => ({
            ...state,
            isLoading: true,
        }),
    )
    .handleAction(
        fetchGeoRegionInfoActions.success,
        (state, {payload}): IGeoRegionInfoReducer => ({
            isLoading: false,
            isError: false,
            data: payload,
        }),
    )
    .handleAction(
        fetchGeoRegionInfoActions.failure,
        (): IGeoRegionInfoReducer => ({
            isLoading: false,
            isError: true,
            data: undefined,
        }),
    );

export default geoRegionInfoReducer;
