import {Request} from '@yandex-data-ui/core/lib/types';

import {CustomThunkAction} from 'reducers/trains/customDispatch';

import {getHotelRegionSlugs} from 'projects/depreacted/hotels/pages/GeoRegionPage/utilities/getHotelRegionSlugs';

import {hotelsSearchService} from 'serviceProvider';

import {fetchGeoRegionInfoActions} from './actions';

export const fetchGeoRegionInfo = (req: Request): CustomThunkAction<void> => {
    return async dispatch => {
        try {
            const {regionSlug = '', filterSlug} = getHotelRegionSlugs(req.path);
            const geoRegionInfoResponse = await hotelsSearchService
                .provider(req && req.container)
                .getGeoRegionInfo({regionSlug, filterSlug});

            dispatch(fetchGeoRegionInfoActions.success(geoRegionInfoResponse));
        } catch (error) {
            dispatch(fetchGeoRegionInfoActions.failure());
        }
    };
};
