import {createAsyncAction, createAction, ActionType} from 'typesafe-actions';

import {IHotelImagesQuantitativeParams, IHotelImages} from './types';

import {HOTEL_IMAGES_ACTION_TYPES} from './actionTypes';

export const getHotelImagesActions = createAsyncAction(
    HOTEL_IMAGES_ACTION_TYPES.START_HOTEL_IMAGES_REQUEST,
    HOTEL_IMAGES_ACTION_TYPES.SUCCESS_HOTEL_IMAGES_REQUEST,
    HOTEL_IMAGES_ACTION_TYPES.FAILED_HOTEL_IMAGES_REQUEST,
)<IHotelImagesQuantitativeParams, IHotelImages, undefined>();

export const resetHotelImagesAction = createAction(
    HOTEL_IMAGES_ACTION_TYPES.RESET_HOTEL_IMAGES,
)();

export type HotelImagesRequestActionsType = ActionType<
    typeof getHotelImagesActions | typeof resetHotelImagesAction
>;
export type GetHotelImagesActionType = (
    params: IHotelImagesQuantitativeParams,
) => void;
export type HotelImagesActionsType = HotelImagesRequestActionsType;
