import {createAsyncAction, createAction, ActionType} from 'typesafe-actions';

/* Types */

import {
    IHotelInfo,
    IHotelInfoRequestParams,
    ISimilarHotelsInfo,
    IHotelReviewsInfo,
    IHotelOffersInfo,
} from './types';
import {IHotelReviewReaction} from 'types/hotels/hotel/IHotelTextReview';
import {IRequiredOfferParams} from 'types/hotels/offer/IHotelOffer';
import IAddFavoriteHotelRequestParams from 'server/api/HotelsFavoritesAPI/types/IAddFavoriteHotelRequestParams';
import {IRemoveFavoriteHotelByPermalinkRequestParams} from 'server/api/HotelsFavoritesAPI/types/IRemoveFavoriteHotelsRequestParams';

import {HOTEL_INFO_ACTION_TYPES} from './actionTypes';

/* Actions */

/* 1 Fetch HotelInfo */
/* 1.1 Получение общей информации об отеле */
export const getHotelInfoActions = createAsyncAction(
    HOTEL_INFO_ACTION_TYPES.START_HOTEL_INFO_REQUEST,
    HOTEL_INFO_ACTION_TYPES.SUCCESS_HOTEL_INFO_REQUEST,
    HOTEL_INFO_ACTION_TYPES.FAILED_HOTEL_INFO_REQUEST,
)<IHotelInfoRequestParams, IHotelInfo, undefined>();
/* 1.2 Сброс состояния к начальному */
export const resetHotelInfoToInitialAction = createAction(
    HOTEL_INFO_ACTION_TYPES.RESET_HOTEL_INFO_TO_INITIAL,
)();

/* 2 Reviews */
/* 2.1 Обновление общего числа отзывов отеля */
export const setHotelInfoTotalReviewsAction = createAction(
    HOTEL_INFO_ACTION_TYPES.SET_HOTEL_INFO_TOTAL_REVIEWS,
)<IHotelReviewsInfo>();
/* 2.2 Оптимистичная установка реакции пользователя  */
export const setHotelInfoReviewReactionAction = createAction(
    HOTEL_INFO_ACTION_TYPES.SET_HOTEL_INFO_REVIEW_REACTION,
)<IHotelReviewReaction>();

/* 3 SearchParams */
/* 3.1 Обновление поисковых параметров */
export const setHotelInfoSearchParamsAction = createAction(
    HOTEL_INFO_ACTION_TYPES.SET_HOTEL_INFO_SEARCH_PARAMS,
)<IRequiredOfferParams>();

/* 4 Offers */
/* 4.1 Полинг оферов на главном табе */
export const getHotelInfoOffersActions = createAsyncAction(
    HOTEL_INFO_ACTION_TYPES.START_HOTEL_OFFERS_POLLING_REQUEST,
    HOTEL_INFO_ACTION_TYPES.SUCCESS_HOTEL_OFFERS_POLLING_REQUEST,
    HOTEL_INFO_ACTION_TYPES.FAILED_HOTEL_OFFERS_POLLING_REQUEST,
)<undefined, IHotelOffersInfo, undefined>();

/* 5 SimilarHotels */
/* 5.1 Полинг похожих отелей */
export const getSimilarHotelsActions = createAsyncAction(
    HOTEL_INFO_ACTION_TYPES.START_SIMILAR_HOTELS_POLLING,
    HOTEL_INFO_ACTION_TYPES.SUCCESS_SIMILAR_HOTELS_POLLING,
    HOTEL_INFO_ACTION_TYPES.FAILED_SIMILAR_HOTELS_POLLING,
)<undefined, ISimilarHotelsInfo, undefined>();

/* 6 AdditionalHotelInfo */
/* 6.1 Асинхронные вспомогательные данные для страницы отеля */
export const getAdditionalHotelInfoAction = createAction(
    HOTEL_INFO_ACTION_TYPES.GET_ADDITIONAL_HOTEL_INFO,
)();
/* 6.2 Остановить выполнение получения вспомогательных данных для страницы отеля */
export const stopHotelInfoActionsAction = createAction(
    HOTEL_INFO_ACTION_TYPES.STOP_HOTEL_INFO_ACTIONS,
)();

/* 7. SyncWithLocation */
/* 7.1 Синхронизация поисковых параметров с location */
export const syncHotelInfoSearchParamsWithLocation = createAction(
    HOTEL_INFO_ACTION_TYPES.SYNC_HOTEL_INFO_SEARCH_PARAMS_WITH_LOCATION,
)();

/* Action Types */

/* 1 Fetch HotelInfo */
export type HotelInfoRequestActionsType = ActionType<
    typeof getHotelInfoActions
>;
export type GetHotelInfoActionType = (params: IHotelInfoRequestParams) => void;
export type StopHotelInfoActionsActionType = () => void;
export type ResetHotelInfoToInitialActionType =
    typeof resetHotelInfoToInitialAction;

/* 2 Reviews */
export type SetHotelInfoTotalReviewsActionType = ActionType<
    typeof setHotelInfoTotalReviewsAction
>;
export type HotelInfoReviewReactionActionsType = ActionType<
    typeof setHotelInfoReviewReactionAction
>;
export type SetHotelInfoReviewReactionActionType = (
    params: IHotelReviewReaction,
) => void;

/* 3 SearchParams */
export type HotelInfoSearchParamsActionsType = ActionType<
    typeof setHotelInfoSearchParamsAction
>;
export type SetHotelInfoSearchParamsActionType = (
    params: IRequiredOfferParams,
) => void;

/* 4 Offers */
export type HotelInfoOffersRequestActionsType = ActionType<
    typeof getHotelInfoOffersActions
>;
export type GetHotelInfoOffersActionType = () => void;

/* 5 SimilarHotels */
export type SimilarHotelsRequestActionsType = ActionType<
    typeof getSimilarHotelsActions
>;
export type GetSimilarHotelsActionType = () => void;

/* 6 AdditionalHotelInfo */
export type GetAdditionalHotelInfoActionType = () => void;

/* 7. Favorites */
export const changeHotelsIsFavoriteOnHotelPageActions = createAsyncAction(
    HOTEL_INFO_ACTION_TYPES.START_CHANGE_HOTELS_IS_FAVORITE_REQUEST,
    HOTEL_INFO_ACTION_TYPES.SUCCESS_CHANGE_HOTELS_IS_FAVORITE_REQUEST,
    HOTEL_INFO_ACTION_TYPES.FAILED_CHANGE_HOTELS_IS_FAVORITE_REQUEST,
)<
    | IAddFavoriteHotelRequestParams
    | IRemoveFavoriteHotelByPermalinkRequestParams,
    undefined,
    undefined
>();
export type ChangeHotelsIsFavoriteOnHotelPageType =
    typeof changeHotelsIsFavoriteOnHotelPageActions.request;

export type ChangeHotelsIsFavoriteOnHotelPageActionsType = ActionType<
    typeof changeHotelsIsFavoriteOnHotelPageActions
>;

export const changeIsOpenForNoMoreFavoritesModalAction = createAction(
    HOTEL_INFO_ACTION_TYPES.CHANGE_IS_OPEN_FOR_NO_MORE_FAVORITES_MODAL,
)<boolean>();

export type ChangeIsOpenForNoMoreFavoritesModalActionType =
    typeof changeIsOpenForNoMoreFavoritesModalAction;

export type HotelInfoActionsType =
    | HotelInfoRequestActionsType
    | HotelInfoReviewReactionActionsType
    | HotelInfoSearchParamsActionsType
    | HotelInfoOffersRequestActionsType
    | SimilarHotelsRequestActionsType
    | SetHotelInfoTotalReviewsActionType
    | ActionType<ResetHotelInfoToInitialActionType>
    | ActionType<ChangeIsOpenForNoMoreFavoritesModalActionType>
    | ChangeHotelsIsFavoriteOnHotelPageActionsType;
