import {
    MAIN_TAB_IMAGES_LIMIT,
    MAIN_TAB_SIMILAR_HOTELS_LIMIT,
} from 'projects/depreacted/hotels/constants/hotelPage';
import {
    DEFAULT_TEXT_REVIEW_QUANTITATIVE,
    DEFAULT_BOT_TEXT_REVIEW_QUANTITATIVE,
} from 'projects/depreacted/hotels/constants/reviews';

import {Request} from '@yandex-data-ui/core/lib/types';

import {setSnackbarInfo} from 'reducers/common/snackbar/actions';
import {
    getHotelReviewsActions,
    resetHotelReviewsAction,
} from 'reducers/depreacted/hotels/hotelPage/reviews/list/actions';

import environmentConfigSelector from 'selectors/common/environmentConfigSelector';

import {getHotelIdentifier} from 'projects/depreacted/hotels/utilities/getHotelIdentifier/getHotelIdentifier';
import {
    validateSearchHotelsAdultsParam,
    validateSearchHotelsParams,
} from 'projects/depreacted/hotels/utilities/validateSearchHotelsParams/validateSearchHotelsParams';
import {
    getHotelOfferToken,
    getOfferAttributionParamsByLocation,
} from 'projects/depreacted/hotels/utilities/getHotelPageParams/getOfferAttributionParamsByLocation';
import {getHotelReviewsForBots} from 'projects/depreacted/hotels/utilities/reviews/getHotelReviewsForBots';
import {getAttributionParams} from 'projects/depreacted/hotels/utilities/getAttributionParams/getAttributionParams';

import {hotelSearchService, hotelsFavoritesService} from 'serviceProvider';

import {
    getHotelInfoActions,
    changeIsOpenForNoMoreFavoritesModalAction,
    changeHotelsIsFavoriteOnHotelPageActions,
} from './actions';

export const fetchHotelInfo = (req: Request): any => {
    return async (dispatch, getState) => {
        try {
            const [, regionSlug, hotelSlug] = req.path
                ? req.path.split('/').filter(Boolean)
                : [];
            const queryParams = req.query;
            const {debugForceLayout} = queryParams;
            const reduxState = getState();
            const {tld} = environmentConfigSelector(reduxState);
            const reviewsParams = req.isBot
                ? DEFAULT_BOT_TEXT_REVIEW_QUANTITATIVE
                : DEFAULT_TEXT_REVIEW_QUANTITATIVE;

            const {
                hotelPermalink,
                adults,
                childrenAges,
                checkinDate,
                checkoutDate,
                searchPagePollingId,
            } = validateSearchHotelsParams(queryParams);

            const optionsProps = {
                full: true,
            };

            const params = {
                adults: validateSearchHotelsAdultsParam(
                    adults,
                    checkinDate,
                    checkoutDate,
                ),
                childrenAges,
                checkinDate,
                checkoutDate,
                searchPagePollingId,
                domain: tld,
                similarHotelLimit: MAIN_TAB_SIMILAR_HOTELS_LIMIT,
                imageLimit: MAIN_TAB_IMAGES_LIMIT,
                debugForceLayout,
                ...reviewsParams,
                ...getHotelIdentifier({hotelPermalink, regionSlug, hotelSlug}),
                ...getHotelOfferToken(queryParams),
                ...getOfferAttributionParamsByLocation(queryParams),
                ...optionsProps,
            };

            const hotelInfoResponse = await hotelSearchService
                .provider(req && req.container)
                .getHotelInfo(params);

            dispatch(getHotelInfoActions.success(hotelInfoResponse));
            dispatch(resetHotelReviewsAction());
            dispatch(
                getHotelReviewsActions.success(
                    req.isBot
                        ? getHotelReviewsForBots(hotelInfoResponse.reviewsInfo)
                        : hotelInfoResponse.reviewsInfo,
                ),
            );
        } catch (error) {
            dispatch(getHotelInfoActions.failure());
        }
    };
};

export interface IAddFavoriteHotelParams {
    requestParams: any;
    message?: React.ReactElement | string;
}

export const addFavoriteHotel = ({
    requestParams: {permalink},
    message,
}: IAddFavoriteHotelParams): any => {
    return async dispatch => {
        try {
            const fillRequestParams: any = {
                permalink,
                ...getAttributionParams(),
            };

            const result = await hotelsFavoritesService
                .provider()
                .addFavoriteHotel(fillRequestParams);

            if (
                'error' in result &&
                result.error &&
                result.error === 'EAddToFavoritesError.HOTEL_LIMIT_EXCEEDED'
            ) {
                dispatch(changeIsOpenForNoMoreFavoritesModalAction(true));

                return;
            } else if ('error' in result && !result.error) {
                dispatch(changeHotelsIsFavoriteOnHotelPageActions.success());

                if (message) {
                    dispatch(
                        setSnackbarInfo({
                            lastAction: `${permalink}-add`,
                            hasCancellation: false,
                            message,
                            page: 'hotel',
                        }),
                    );
                }
            }
        } catch (error) {
            dispatch(changeHotelsIsFavoriteOnHotelPageActions.failure());
        }
    };
};

export const removeFavoriteHotel = ({permalink}: any): any => {
    return async dispatch => {
        try {
            const requestParams = {
                permalink,
                ...getAttributionParams(),
            };

            await hotelsFavoritesService
                .provider()
                .removeFavoriteHotels(requestParams);

            dispatch(changeHotelsIsFavoriteOnHotelPageActions.success());
        } catch (error) {
            dispatch(changeHotelsIsFavoriteOnHotelPageActions.failure());
        }
    };
};
