import {IHotel, IHotelIdentifier} from 'types/hotels/hotel/IHotel';
import {IHotelsAttributionParams} from 'types/hotels/common/IAttribution';
import {IHotelSeoInfo} from 'types/hotels/hotel/ISeoInfo';
import {
    IRequiredOfferParams,
    IDebugOfferSearchParams,
} from 'types/hotels/offer/IHotelOffer';
import {IFeatureRatingInfo} from 'types/hotels/hotel/IFeatureRating';
import {IExtraVisitAndUserParams} from 'types/hotels/common/IExtraVisitAndUserParams';

import {IBaseErrorResponse} from 'server/controllers/hotelsApiController/HotelsBaseController';

import {IHotelReviewsInfo} from './IHotelReviews';
import {IHotelOffersInfo} from './IOffersInfo';
import {ISimilarHotelsInfo} from './ISimilarHotels';
import {ETextReviewRankingType} from './ETextReviewRankingType';
import {IBreadcrumbs} from './IHotelBreadcrumbs';

/* 1. RequestParams */

export interface IHotelInfoRequestParams
    extends IHotelsAttributionParams,
        IHotelIdentifier,
        Partial<IRequiredOfferParams>,
        Partial<IDebugOfferSearchParams> {
    domain: string;
    textReviewLimit?: number;
    similarHotelLimit?: number;
    imageLimit?: number;
    keyPhraseLimit?: number;
    label?: string;
    token?: string;
    full?: boolean;
    experiments?: string;
    /** Способ сортировки отзывов. */
    textReviewRanking?: ETextReviewRankingType;
    /**
     * SearchPagePollingId
     * id итерации поиска на портале
     * он должен браться из урла и прозрачно пробрасываться на бек.
     */
    searchPagePollingId?: string;
}

/* 2. SuccessResponse */

export interface IHotelInfoResponse extends IHotelInfo {}

export interface IHotelInfo {
    searchParams?: IRequiredOfferParams;
    parentRequestId: string;
    hotel: IHotel;
    hotelDescription: IHotelDescription;
    breadcrumbs: IBreadcrumbs;
    /*
     * Хлебные крошки для SEO. Отображаются на странице отеля
     * Первый пункт "Отели" отображается всегда (не передаётся в seoBreadcrumbs)
     * Пример отображения: Отели -> Свердловская область -> Екатеринбург -> Hyatt Regency Ekaterinburg 5*
     * !!! здесь заполняется только items, geoRegions не заполняется
     * */
    seoBreadcrumbs: IBreadcrumbs;
    offersInfo: IHotelOffersInfo;
    similarHotelsInfo: ISimilarHotelsInfo;
    reviewsInfo: IHotelReviewsInfo;
    ratingsInfo: IRatingsInfo;
    seoInfo: IHotelSeoInfo;
    extraVisitAndUserParams: IExtraVisitAndUserParams;
}

/* LayoutType */
export enum LayoutType {
    META = 'M',
    BOOK = 'B',
}

/* HotelDescription */
export interface IHotelDescription {
    text?: string;
}

/* Ratings */
export interface IRatingsInfo {
    teaser?: string;
    featureRatings: IFeatureRatingInfo[];
}

/* 3. ErrorResponse */

export interface IHotelInfoError extends IBaseErrorResponse {}
