import {HotelSlugType} from 'types/hotels/hotel/IHotel';
import {ITextReview, IKeyPhrase} from 'types/hotels/hotel/IHotelTextReview';

import {IBaseErrorResponse} from 'server/controllers/hotelsApiController/HotelsBaseController';

import {ETextReviewRankingType} from './ETextReviewRankingType';

/* 1. RequestParams */

export interface IHotelReviewsQuantitativeAndFilterParams {
    textReviewLimit?: number;
    textReviewOffset?: number;
    keyPhraseLimit?: number;
    keyPhraseFilter?: string;
    /** Способ сортировки отзывов. */
    textReviewRanking?: ETextReviewRankingType;
}

export interface IHotelReviewsInfoRequestParams
    extends IHotelReviewsQuantitativeAndFilterParams {
    hotelSlug: HotelSlugType;
    parentRequestId: string;

    /** Включить использование тестового инстанса UGC в АПИ. Работает только в тестинге */
    enabledTestUgc?: boolean;
}

/* 2. SuccessResponse */

export interface IHotelReviewsInfoResponse {
    reviewsInfo: IHotelReviewsInfo;
}

export interface IHotelReviewsInfo {
    totalTextReviewCount: number;
    textReviews: ITextReview[];
    totalKeyPhraseCount: number;
    keyPhrases: IKeyPhrase[];
    /** Текстовыей отзыв текущего пользователя. */
    userTextReview?: ITextReview;

    currentSortingOption?: ETextReviewRankingType;

    /** Можно ли дозагрузить еще отзывы.
     * Если при hasMore: false запрашивать следующую пачку отзывов, то апи вернет 400
     */
    hasMore: boolean;
}

/* 3. ErrorResponse */

export interface IHotelReviewsInfoError extends IBaseErrorResponse {}
