import {createAsyncAction, ActionType, createAction} from 'typesafe-actions';

import {
    IAddHotelReviewRequest,
    IAddHotelReviewResponse,
} from 'server/api/HotelSearchAPI/types/IAddHotelReview';

import {HOTEL_ADD_REVIEW_ACTION_TYPES} from './actionTypes';

export const addHotelReviewActions = createAsyncAction(
    HOTEL_ADD_REVIEW_ACTION_TYPES.ADD_HOTEL_REVIEW_REQUEST,
    HOTEL_ADD_REVIEW_ACTION_TYPES.ADD_HOTEL_REVIEW_SUCCESS,
    HOTEL_ADD_REVIEW_ACTION_TYPES.ADD_HOTEL_REVIEW_FAIL,
)<IAddHotelReviewRequest, IAddHotelReviewResponse, undefined>();

export const resetAddHotelReviewAction = createAction(
    HOTEL_ADD_REVIEW_ACTION_TYPES.ADD_HOTEL_REVIEW_RESET,
)();

export type AddReviewRequestActionsType = ActionType<
    typeof addHotelReviewActions | typeof resetAddHotelReviewAction
>;
