import {createReducer} from 'typesafe-actions';

import {
    deleteHotelReviewActions,
    DeleteReviewRequestActionsType,
} from './actions';

export interface IDeleteReviewReducer {
    isSubmitting: boolean;
    isSuccess: boolean;
    hasError: boolean;
}

/* Initial State */
const initialState: IDeleteReviewReducer = {
    isSubmitting: false,
    isSuccess: false,
    hasError: false,
};

/* Reducer */
export default createReducer<
    IDeleteReviewReducer,
    DeleteReviewRequestActionsType
>(initialState)
    .handleAction(deleteHotelReviewActions.request, state => ({
        ...state,
        isSubmitting: true,
        isSuccess: false,
        hasError: false,
    }))
    .handleAction(deleteHotelReviewActions.success, state => {
        return {
            ...state,
            isSubmitting: false,
            isSuccess: true,
            hasError: false,
        };
    })
    .handleAction(deleteHotelReviewActions.failure, state => {
        return {
            ...state,
            isSubmitting: false,
            isSuccess: false,
            hasError: true,
        };
    });
